% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterEvents.R
\name{filterByCoverage}
\alias{filterByCoverage}
\title{Filter splicing events based on coverage.}
\usage{
filterByCoverage(events, avg_reads = 5)
}
\arguments{
\item{events}{a maser object.}

\item{avg_reads}{numeric, average number of reads covering the splice event.}
}
\value{
a maser object.
}
\description{
Filter splicing events based on coverage.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)
}
