% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvents.R
\name{dotplot}
\alias{dotplot}
\title{Dotplot representation of splicing events.}
\usage{
dotplot(events, type = c("A3SS", "A5SS", "SE", "RI", "MXE"), fdr = 0.05,
  deltaPSI = 0.1)
}
\arguments{
\item{events}{a maser object.}

\item{type}{character indicating splice type. Possible values are
\code{c("A3SS", "A5SS", "SE", "RI", "MXE")}}

\item{fdr}{numeric, FDR (False Discovery Rate) cutoff.}

\item{deltaPSI}{numeric, absolute minimum PSI (Percent spliced-in) change}
}
\value{
a ggplot object.
}
\description{
Dotplot representation of splicing events.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)
dotplot(hypoxia_filt, type = "SE")
}
