% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maser.R
\docType{methods}
\name{counts,Maser-method}
\alias{counts,Maser-method}
\title{Retrieve raw read counts values from a maser object.}
\usage{
\S4method{counts}{Maser}(object, type = c("A3SS", "A5SS", "SE", "RI", "MXE"))
}
\arguments{
\item{object}{a maser object.}

\item{type}{a character indicating the splice type. Possible values 
are  \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}
}
\value{
a matrix.
}
\description{
Retrieve raw read counts values from a maser object.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
head(counts(hypoxia, "SE"))
}
