% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maser.R
\docType{methods}
\name{PSI,Maser,character-method}
\alias{PSI,Maser,character-method}
\title{Retrieve PSI (percent spliced in) values from a maser object.}
\usage{
\S4method{PSI}{Maser,character}(events, type = c("A3SS", "A5SS", "SE", "RI",
  "MXE"))
}
\arguments{
\item{events}{a maser object.}

\item{type}{a character indicating the splice type. Possible values 
are  \code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}
}
\value{
a matrix.
}
\description{
Retrieve PSI (percent spliced in) values from a maser object.
}
\examples{
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
head(PSI(hypoxia, "SE"))
}
