\name{maColorBar}
\alias{maColorBar}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Calibration bar for color images}
\description{
This function produces a color image (color bar) which can be used for
the legend to another color image obtained from the functions
\code{\link{image}}, \code{\link{maImage}}, or
\code{\link{maImage.func}}. 
}
\usage{
maColorBar(x, horizontal=TRUE, col=heat.colors(50), scale=1:length(x), k=10, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{If "numeric", a vector containing the "z" values in the
    color image, i.e., the values which are represented in the color
    image. Otherwise, a "character" vector representing colors.}
  \item{horizontal}{If \code{TRUE}, the values of \code{x} are
    represented as vertical color strips in the image, else, the values
    are represented as horizontal color strips.} 
  \item{col}{Vector of colors such as that generated by
    \code{rainbow}, \code{heat.colors},
    \code{topo.colors}, \code{terrain.colors}, or similar
    functions. In addition to these color palette functions, a new
    function  \code{\link{maPalette}} was defined to generate color
    palettes from user supplied low, middle, and high color values.} 
  \item{scale}{A "numeric" vector specifying the "z" values in the color
    image. This is used when the argument \code{x} is a
    "character" vector representing color information.}
  \item{k}{Object of class "numeric", for the number of labels displayed on 
    the bar.}
  \item{\dots}{Optional graphical parameters, see \code{\link{par}}.}
}
\references{
S. Dudoit and Y. H. Yang. (2002). Bioconductor R packages for exploratory analysis and normalization of cDNA microarray data. In G. Parmigiani, E. S. Garrett, R. A. Irizarry and S. L. Zeger, editors, \emph{The Analysis of Gene Expression Data: Methods and Software}, Springer, New York.
}
\author{Sandrine Dudoit, \url{http://www.stat.berkeley.edu/~sandrine}, Yee Hwa (Jean) Yang.}
\seealso{\code{\link{image}}, \code{\link{maImage}}, \code{\link{maImage.func}}, \code{\link{maPalette}}.}
\examples{
par(mfrow=c(3,1))
Rcol <- maPalette(low="white", high="red", k=10)
Gcol <- maPalette(low="white", high="green", k=50)
RGcol <- maPalette(low="green", high="red", k=100)
maColorBar(Rcol)
maColorBar(Gcol, scale=c(-5,5))
maColorBar(1:50, col=RGcol)

par(mfrow=c(1,3))
x<-seq(-1, 1, by=0.01)
maColorBar(x, col=Gcol, horizontal=FALSE, k=11)
maColorBar(x, col=Gcol, horizontal=FALSE, k=21)
maColorBar(x, col=Gcol, horizontal=FALSE, k=51)
}
\keyword{aplot}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line
