% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrSamplepairsfiltered}
\alias{MarrSamplepairsfiltered}
\alias{MarrSamplepairsfiltered,Marr-method}
\title{Generic function that returns the Marr filtered sample pairs}
\usage{
MarrSamplepairsfiltered(object)

\S4method{MarrSamplepairsfiltered}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
The percent of reproducible features based on a
threshold value after applying maximum rank reproducibility.
}
\description{
Given a Marr object, this function returns the
Marr filtered sample pairs

Accessors for the 'MarrSamplepairsfiltered'
slot of a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrSamplepairsfiltered(data_Marr)

}
