% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterData.R
\name{MarrFilterData}
\alias{MarrFilterData}
\title{Filter by Maximum Rank Reproducibility}
\usage{
MarrFilterData(object, by = c("both", "features", "samplePairs"))
}
\arguments{
\item{object}{a Marr object from \code{Marr}}

\item{by}{String specifying which reproducibility values to filter by. 
Options include "features" to filter features according to their 
reproducibility, "samplePairs" to filter samples according to the 
reproducibility of sample pairs, or "both" to filter both features and sample
 pairs according to their respective reproducibility. Default is "both".}
}
\value{
A list of \code{data.frame}'s or a \code{SummarizedExperiment}. 
If a \code{data.frame} was originally input into the \code{Marr} function,
 a list with three elements, \code{filteredData}, 
\code{removedSamples}, and \code{removedFeatures}, will be returned. If a
\code{SummarizedExperiment} was originally input, output will be a 
\code{SummarizedExperiment} with the assay filtered and with two metadata
objects, \code{removedSamples} and \code{removedFeatures} added.
}
\description{
Filters \code{Marr} object according to the Maximum Rank 
Reproducibility of the features, samples pairs, or both. Features are removed
if their reproducibility per sample pair is less than \code{pFeatures}.
Samples are removed if their sample pair reproducibility per feature is less
than \code{pSamplepairs} for all pairings of that sample and the other
samples in the set.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrFilterData(data_Marr, by = "both")

}
