% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrFeatures}
\alias{MarrFeatures}
\alias{MarrFeatures,Marr-method}
\title{Generic function that returns the Marr features}
\usage{
MarrFeatures(object)

\S4method{MarrFeatures}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
The distribution of percent reproducible sample pairs
(row-wise) per feature after applying the maximum rank
reproducibility.
}
\description{
Given a Marr object, this function returns the
Marr features

Accessors for the 'MarrFeatures' slot
of a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrFeatures(data_Marr)

}
