% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotScores.R
\name{PlotScores_Categorical}
\alias{PlotScores_Categorical}
\title{Plot Gene Set Scores by Group or Continuous Variable}
\usage{
PlotScores_Categorical(
  data,
  metadata,
  gene_sets,
  method = c("ssGSEA", "logmedian", "ranking"),
  ColorVariable = NULL,
  GroupingVariable = NULL,
  ColorValues = NULL,
  ConnectGroups = FALSE,
  ncol = NULL,
  nrow = NULL,
  title = NULL,
  widthTitle = 10,
  titlesize = 12,
  limits = NULL,
  legend_nrow = NULL,
  pointSize = 2,
  xlab = NULL,
  labsize = 10,
  compute_cohen = TRUE,
  cond_cohend = NULL,
  pvalcalc = FALSE,
  mode = c("simple", "medium", "extensive"),
  widthlegend = 22,
  cohen_threshold = 0.6,
  colorPalette = "Set3"
)
}
\arguments{
\item{data}{A data frame of Normalised (non-transformed) counts where each
row is a gene and each column is a sample. Row names should contain gene
names, and column names should contain sample identifiers. \strong{(Required)}}

\item{metadata}{A data frame describing the attributes of each sample, where
each row corresponds to a sample and each column to an attribute. The first
column should contain sample identifiers (i.e., the column names of
\code{data}). \strong{(Required if method = "all")}}

\item{gene_sets}{Gene set input. \strong{(Required)}
\itemize{
\item \strong{Unidirectional gene sets}: Provide a named list where each element is
a vector of gene names representing a gene signature.
\item \strong{Bidirectional gene sets}: Provide a named list where each element is
a data frame with two columns:
\itemize{
\item The \strong{first column} contains gene names.
\item The \strong{second column} indicates the expected direction of enrichment
(1 for upregulated genes, -1 for downregulated genes).
}
}}

\item{method}{A character string indicating the scoring method to use.
Options are \code{"ssGSEA"}, \code{"logmedian"} or \code{"ranking"}. Defaults to
\code{"logmedian"}.}

\item{ColorVariable}{Optional. Name of the metadata column to use for point
color in plots.}

\item{GroupingVariable}{Optional. Name of the metadata column to use for
group comparison.}

\item{ColorValues}{Optional. Named vector of colors to use for each group in
\code{ColorVariable} or \code{GroupingVariable}.}

\item{ConnectGroups}{Logical. If TRUE, connects points of the same sample
across conditions.}

\item{ncol}{Number of columns in the facet layout of the plot.}

\item{nrow}{Number of rows in the facet layout of the plot.}

\item{title}{Optional. Main title of the plot.}

\item{widthTitle}{Numeric. Width of the title area (for alignment purposes).}

\item{titlesize}{Numeric. Font size of the title text.}

\item{limits}{Optional numeric vector of length 2 specifying y-axis limits.}

\item{legend_nrow}{Optional. Number of rows in the plot legend.}

\item{pointSize}{Numeric. Size of the points in the plots.}

\item{xlab}{Optional. Label for the x-axis.}

\item{labsize}{Numeric. Font size for axis and facet labels.}

\item{compute_cohen}{Logical. If TRUE, computes Cohen's d effect sizes
between groups.}

\item{cond_cohend}{Optional. Specify a condition or comparison subset for
calculating Cohen's d.}

\item{pvalcalc}{Logical. If TRUE, computes p-values for group comparisons.}

\item{mode}{Character string indicating comparison complexity. Options:
\code{"simple"}, \code{"medium"}, \code{"extensive"}.}

\item{widthlegend}{Numeric. Width of the legend area in volcano plots.}

\item{cohen_threshold}{Numeric. Cohen's d threshold to highlight effect size
in volcano plots (default = 0.6).}

\item{colorPalette}{Character. Name of RColorBrewer palette for coloring
(default = \code{"Set3"}).}
}
\value{
A \code{ggplot} or a \code{ggpubr::ggarrange} object depending on the input and
parameters:
\itemize{
\item If \code{GroupingVariable} is \code{NULL}, returns a faceted grid of density plots
(one per gene set).
\item If \code{GroupingVariable} is provided and \code{method != "all"}, returns a faceted
grid of violin plots overlaid with jittered sample points and median bars,
optionally annotated with Cohen's d or f and p-values.
\item Each individual plot corresponds to one gene set score computed using the
selected method.
}
}
\description{
This function computes and visualizes gene set enrichment scores using
various methods, optionally comparing across groups or numeric variables. It
supports categorical and numeric comparisons, statistical testing, Cohen's d
effect sizes, and visualizations such as heatmaps and volcano plots.
}
\details{
Four methods are available:
\itemize{
\item \strong{ssGSEA}: Uses the single-sample Gene Set Enrichment Analysis (ssGSEA)
method to compute an enrichment score
for each signature in each sample using an adaptation of the \code{gsva()}
function from the \code{GSVA} package.
\item \strong{logmedian}: Computes the score as the sum of the Normalised
(log2-median-centered) expression values of the
signature genes divided by the number of genes in the signature.
\item \strong{ranking}: Computes gene signature scores for each sample by ranking
the expression of signature genes
in the dataset and normalizing the score based on the total number of genes.
\item \strong{all}: Computes gene signature scores using all three methods
(\code{ssGSEA}, \code{logmedian}, and \code{ranking}).
Returns a heatmap summarizing Cohen's d for all metric combinations of the
variables of interest.
}

Depending on the method and the type of variable (categorical, numeric, or
\code{NULL}), the function produces different plots:
\itemize{
\item \strong{If \code{method = "all"}} and the variable is \strong{categorical}, a heatmap of
Cohen's d or F statistics and a volcano plot showing contrasts between all
groups of that variable are produced.
\item \strong{If \code{method = "all"}} and the variable is \strong{numeric}, a heatmap of
Cohen's f and a volcano plot are produced.
\item \strong{If \code{method != "all"}} and the variable is \strong{categorical}, a violin plot
for each signature is generated.
\item \strong{If \code{method != "all"}} and the variable is \code{NULL}, a density plot of the
score distribution is displayed.
\item \strong{If \code{method != "all"}} and the variable is \strong{numeric}, a scatter plot is
created to show the relationship between the scores and the numeric variable.
\item \strong{If \code{method = "all"}} and the variable is \strong{categorical}, the function
returns a heatmap of Cohen's d or F statistics and a volcano plot showing
contrasts between all groups of that variable.
\item \strong{If \code{method = "all"}} and the variable is \strong{numeric}, a heatmap of
Cohen's f and a volcano plot will be produced.
\item \strong{If \code{method != "all"}} and the variable is \strong{categorical}, a violin
plot for each signature will be displayed.
\item \strong{If \code{method != "all"}} and the variable is \code{NULL}, a density plot of
the score distribution will be displayed.
\item \strong{If \code{method != "all"}} and the variable is \strong{numeric}, a scatter plot
will be generated to show the relationship between the scores and the numeric
variable.
}
}
\keyword{internal}
