% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-MergedGInteractions.R
\name{selectionMethod}
\alias{selectionMethod}
\alias{selectionMethod,MergedGInteractions-method}
\title{Get selectionMethod from MergedGInteractions object}
\usage{
selectionMethod(x, ...)

\S4method{selectionMethod}{MergedGInteractions}(x, ...)
}
\arguments{
\item{x}{MergedGInteractions object.}

\item{...}{Additional arguments.}
}
\value{
A character vector describing which selection
 method was used for merging.
}
\description{
Get selectionMethod from MergedGInteractions object
}
\examples{
## Load required packages
library(data.table, include.only="fread")

## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Reference BEDPE files (loops called with SIP)
bedpeFiles <- c(
    marinerData::FS_5kbLoops.txt(),
    marinerData::WT_5kbLoops.txt()
)
names(bedpeFiles) <- c("FS", "WT")

## Read in bedpeFiles as a list of GInteractions
## Use only first 1000 rows for fast example
giList <-
    lapply(bedpeFiles, fread, nrows=1000) |>
    lapply(as_ginteractions)

## Cluster & merge pairs
x <- mergePairs(x = giList,
                radius = 10e03,
                column = "APScoreAvg")

selectionMethod(x)

}
