% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-hdf5BlockApply.R
\name{hdf5BlockApply}
\alias{hdf5BlockApply}
\alias{hdf5BlockApply,DelayedArray-method}
\title{HDF5-backed blockApply}
\usage{
hdf5BlockApply(x, FUN, sink, grid, sink_grid, verbose = TRUE)

\S4method{hdf5BlockApply}{DelayedArray}(x, FUN, sink, grid, sink_grid, verbose = TRUE)
}
\arguments{
\item{x}{Delayed Array object.}

\item{FUN}{Function that takes one argument
'block' and processes it.}

\item{sink}{HDF5RealizationSink object.}

\item{grid}{ArrayGrid over array `x`.}

\item{sink_grid}{ArrayGrid over `sink`.}

\item{verbose}{Logical - whether block processing
progress should be displayed.}
}
\value{
An HDF5Array object.
}
\description{
Read in array data in blocks, apply function,
and write back to an HDF5 file.
}
\details{
Implements an HDF5-backed option for block
processing on DelayedArray objects.
}
\examples{

## ################################################
## This function is intended for advanced users.
## To learn more about using DelayedArray
## or HDF5-backed objects, see ?DelayedArray or
## ?HDF5Array
###################################################

library(DelayedArray)
library(HDF5Array)
library(rhdf5)

## Create example array that is longer in the
## 3rd dimension (representing interactions)
dims <- c(11L, 11L, 100L, 2L)
a <- array(data=seq(1, prod(dims)), dim=dims)
a <- DelayedArray(a)

## Define spacings, breaking up the longest dim
## Here we are processing in blocks of 10
spacings <- dim(a)
spacings[3] <- ceiling(spacings[3]/10)

## Define storage dimensions (all except those
## over which the function is being applied)
storageDims <- dims[c(1,2,3)]

## Define chunk dimensions for writing to HDF5
chunkDims <- storageDims
chunkDims[3] <- spacings[3]

## Create grid for applying the data (grid)
## and grid for writing to the sink (sink_grid)
grid <- RegularArrayGrid(dims, spacings)
sink_grid <- RegularArrayGrid(storageDims, chunkDims)

## Create HDF5 file for writing
h5 <- tempfile(fileext = ".h5")
h5createFile(h5)

## Define compression for HDF5
compressionLevel <- 0

## Create HDF5-backed realization sink
sink <- HDF5RealizationSink(filepath=h5,
                            name="counts",
                            type="integer",
                            dim=storageDims,
                            chunkdim=chunkDims,
                            level=compressionLevel)

## Wrap function that operates on each block
## this can be anything, here it is sum
FUN <- \(block) apply(block, c(1,2,3), sum)

## Read, apply, and write to HDF5
ans <- hdf5BlockApply(x=a,
                      FUN=FUN,
                      sink=sink,
                      grid=grid,
                      sink_grid=sink_grid,
                      verbose=TRUE)
ans

}
