% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeToxlsx.R
\name{writeToxlsx}
\alias{writeToxlsx}
\title{Write power evaulation results under all scenarios to a .xlsx file.}
\usage{
writeToxlsx(pl, file)
}
\arguments{
\item{pl}{A list produced by \code{\link{powerEval}}.}

\item{file}{A character indicating the name of the output .xlsx file.}
}
\value{
It outputs a .xlsx file including FDR, FDC, power, and precision under various sample sizes,
sequencing depths, and adjusted p-value thresholds.
}
\description{
This function writes power evaulation results to a .xlsx file.
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE46705", test_method = "TRESS")

### write out .xlsx
writeToxlsx(power.test, file = "test_TRESS.xlsx")

}
