% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetMaf.R
\name{subsetMaf}
\alias{subsetMaf}
\title{Subset MAF objects}
\usage{
subsetMaf(
  maf,
  tsb = NULL,
  genes = NULL,
  query = NULL,
  clinQuery = NULL,
  ranges = NULL,
  keepNA = FALSE,
  mult = "first",
  fields = NULL,
  mafObj = TRUE,
  includeSyn = TRUE,
  isTCGA = FALSE,
  dropLevels = TRUE,
  restrictTo = "all",
  verbose = TRUE
)
}
\arguments{
\item{maf}{an MAF object generated by \code{\link{read.maf}}}

\item{tsb}{subset by these samples (Tumor Sample Barcodes)}

\item{genes}{subset by these genes}

\item{query}{query string. e.g, "Variant_Classification == 'Missense_Mutation'" returns only Missense variants.}

\item{clinQuery}{query by clinical variable.}

\item{ranges}{subset by ranges. data.frame with 3 column (chr, start, end). Overlaps are identified by  \code{\link{foverlaps}} function with arguments `type = within`, `mult = all`, `nomatch = NULL`}

\item{keepNA}{Keep NAs while sub-setting for ranges. Default `FALSE` - removes rows with missing loci prior to overlapping. Set to TRUE to keep them as is.}

\item{mult}{When multiple loci in `ranges` match to the variants maf, mult=. controls which values are returned - "all" , "first" (default) or "last". This value is passed to `mult` argument of \code{\link{foverlaps}}}

\item{fields}{include only these fields along with necessary fields in the output}

\item{mafObj}{returns output as MAF class \code{\link{MAF-class}}. Default TRUE}

\item{includeSyn}{Default TRUE, only applicable when mafObj = FALSE. If mafObj = TRUE, synonymous variants will be stored in a seperate slot of MAF object.}

\item{isTCGA}{Is input MAF file from TCGA source.}

\item{dropLevels}{Default TRUE.}

\item{restrictTo}{restrict subset operations to these. Can be 'all', 'cnv', or 'mutations'. Default 'all'. If 'cnv' or 'mutations', subset operations will only be applied on copy-number or mutation data respectively, while retaining other parts as is.}

\item{verbose}{Default TRUE}
}
\value{
subset table or an object of class \code{\link{MAF-class}}
}
\description{
Subsets MAF based on given conditions.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
##Select all Splice_Site mutations from DNMT3A and NPM1
subsetMaf(maf = laml, genes = c('DNMT3A', 'NPM1'),
query = "Variant_Classification == 'Splice_Site'")
##Select all variants with VAF above 30\%
subsetMaf(maf = laml, query = "i_TumorVAF_WU > 30")
##Extract data for samples 'TCGA.AB.3009' and 'TCGA.AB.2933' but only include vaf filed.
subsetMaf(maf = laml, tsb = c('TCGA-AB-3009', 'TCGA-AB-2933'), fields = 'i_TumorVAF_WU')
##Subset by ranges
ranges = data.frame(chr = c("2", "17"), start = c(25457000, 7571720), end = c(25458000, 7590868))
subsetMaf(laml, ranges = ranges)

}
\seealso{
\code{\link{getFields}}
}
