% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareMutSig.R
\name{prepareMutSig}
\alias{prepareMutSig}
\title{Prepares MAF file for MutSig analysis.}
\usage{
prepareMutSig(maf, fn = NULL)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{fn}{basename for output file. If provided writes MAF to an output file with the given basename.}
}
\value{
returns a MAF with gene symbols corrected.
}
\description{
Corrects gene names for MutSig compatibility.
}
\details{
MutSig/MutSigCV is most widely used program for detecting driver genes. However, we have observed that covariates files (gene.covariates.txt and exome_full192.coverage.txt) which are bundled with MutSig have non-standard gene names (non Hugo_Symbols).
This discrepancy between Hugo_Symbols in MAF and non-Hugo_symbols in covariates file causes MutSig program to ignore such genes. For example, KMT2D - a well known driver gene in Esophageal Carcinoma is represented as MLL2 in MutSig covariates. This causes KMT2D to be ignored
from analysis and is represented as an insignificant gene in MutSig results. This function attempts to correct such gene symbols with a manually curated list of gene names compatible with MutSig covariates list.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
prepareMutSig(maf = laml)
}
