% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vaf.R
\name{plotVaf}
\alias{plotVaf}
\title{Plots vaf distribution of genes}
\usage{
plotVaf(
  maf,
  vafCol = NULL,
  genes = NULL,
  top = 10,
  orderByMedian = TRUE,
  keepGeneOrder = FALSE,
  flip = FALSE,
  fn = NULL,
  gene_fs = 0.8,
  axis_fs = 0.8,
  height = 5,
  width = 5,
  showN = TRUE,
  color = NULL
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{vafCol}{manually specify column name for vafs. Default looks for column 't_vaf'}

\item{genes}{specify genes for which plots has to be generated}

\item{top}{if \code{genes} is NULL plots top n number of genes. Defaults to 5.}

\item{orderByMedian}{Orders genes by decreasing median VAF. Default TRUE}

\item{keepGeneOrder}{keep gene order. Default FALSE}

\item{flip}{if TRUE, flips axes. Default FALSE}

\item{fn}{Filename. If given saves plot as a output pdf. Default NULL.}

\item{gene_fs}{font size for gene names. Default 0.8}

\item{axis_fs}{font size for axis. Default 0.8}

\item{height}{Height of plot to be saved. Default 5}

\item{width}{Width of plot to be saved. Default 4}

\item{showN}{if TRUE, includes number of observations}

\item{color}{manual colors. Default NULL.}
}
\value{
Nothing.
}
\description{
Plots vaf distribution of genes as a boxplot. Each dot in the jitter is a variant.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
plotVaf(maf = laml, vafCol = 'i_TumorVAF_WU')

}
