% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticComapre.R
\name{gisticCompare}
\alias{gisticCompare}
\title{compare two GISTIC objects}
\usage{
gisticCompare(
  g1,
  g2,
  g1Name = NULL,
  g2Name = NULL,
  minEvent = 5,
  pseudoCount = FALSE
)
}
\arguments{
\item{g1}{first \code{\link{GISTIC}} object}

\item{g2}{second \code{\link{GISTIC}} object}

\item{g1Name}{optional name for first cohort}

\item{g2Name}{optional name for second cohort}

\item{minEvent}{Consider only cytobands with minimum this number of samples altered in at least one of the cohort for analysis. Helpful to ignore single mutated genes. Default 5.}

\item{pseudoCount}{If TRUE, adds 1 to the contingency table with 0's to avoid `Inf` values in the estimated odds-ratio.}
}
\value{
result list
}
\description{
compare two GISTIC objects
}
\details{
Performs fisher test on 2x2 contingency table generated from two GISTIC objects
}
\seealso{
\code{\link{forestPlot}}

\code{\link{lollipopPlot2}}
}
