% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSignatures.R
\name{extractSignatures}
\alias{extractSignatures}
\title{Extract mutational signatures from trinucleotide context.}
\usage{
extractSignatures(
  mat,
  n = NULL,
  plotBestFitRes = FALSE,
  parallel = 4,
  pConstant = NULL
)
}
\arguments{
\item{mat}{Input matrix of diemnsion nx96 generated by \code{\link{trinucleotideMatrix}}}

\item{n}{decompose matrix into n signatures. Default NULL. Tries to predict best value for \code{n} by running NMF on a range of values and chooses based on cophenetic correlation coefficient.}

\item{plotBestFitRes}{plots consensus heatmap for range of values tried. Default FALSE}

\item{parallel}{Default 4. Number of cores to use.}

\item{pConstant}{A small positive value to add to the matrix. Use it ONLY if the functions throws an \code{non-conformable arrays} error}
}
\value{
a list with decomposed scaled signatures, signature contributions in each sample and NMF object.
}
\description{
Decompose a matrix of 96 substitution classes into \code{n} signatures.
}
\details{
This function decomposes a non-negative matrix into n signatures.
}
\examples{
\dontrun{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
laml.tnm <- trinucleotideMatrix(maf = laml, ref_genome = 'BSgenome.Hsapiens.UCSC.hg19', prefix = 'chr',
add = TRUE, useSyn = TRUE)
library("NMF")
laml.sign <- extractSignatures(mat = laml.tnm, plotBestFitRes = FALSE, n = 2, pConstant = 0.01)
}
}
\seealso{
\code{\link{trinucleotideMatrix}} \code{\link{plotSignatures}} \code{\link{compareSignatures}}
}
