% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSignatures.R
\name{compareSignatures}
\alias{compareSignatures}
\title{Compares identified denovo mutational signatures to known COSMIC signatures}
\usage{
compareSignatures(nmfRes, sig_db = "SBS_v34", verbose = TRUE)
}
\arguments{
\item{nmfRes}{results from \code{\link{extractSignatures}}}

\item{sig_db}{can be \code{legacy}, \code{SBS}, \code{SBS_v34}. Default \code{SBS_v34}}

\item{verbose}{Default TRUE}
}
\value{
list containing cosine smilarities, aetiologies if available, and best match.
}
\description{
Takes results from \code{\link{extractSignatures}} and compares them known COSMIC signatures. Two COSMIC databases are used for comparisons - "legacy" which includes 30 signaures, and "SBS" - which includes updated/refined 65 signatures
}
\details{
SBS signature database was obtained from https://www.synapse.org/#!Synapse:syn11738319.7
}
\seealso{
\code{\link{trinucleotideMatrix}} \code{\link{extractSignatures}} \code{\link{plotSignatures}}
}
