% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankProbes.R
\name{rankProbes}
\alias{rankProbes}
\title{Rank CpG probes}
\usage{
rankProbes(methData, pheno = NULL, paired = FALSE, explanatory = 1,
  covariates = c(), pairColumn = c(), caseGroup = 1, refGroup = 2,
  continuous = NULL, typeInput = "beta", typeAnalysis = "M")
}
\arguments{
\item{methData}{A data frame or a matrix containing Illumina's CpG probes in
rows and samples in columns. A SummarizedExperiment object can be used too}

\item{pheno}{A data frame or a matrix containing samples in rows and
covariates in columns. If NULL (default), pheno is extracted from the
SummarizedExperiment object}

\item{paired}{Perform a paired t-test (default = FALSE)}

\item{explanatory}{The column name or position from pheno used to perform the
comparison between groups (default = first column)}

\item{covariates}{A list or character vector with column names from pheno
used as data covariates in the linear model}

\item{pairColumn}{Only for paired analysis. The column name or position from
pheno used to connect the paired samples (default = NULL)}

\item{caseGroup}{The group name or position from explanatory variable used as
cases to perform the comparison (default = first group)}

\item{refGroup}{The group name or position from explanatory variable used as
reference to perform the comparison (default = second group)}

\item{continuous}{A list or character vector with columns names from pheno
which should be treated as continuous variables (default = none)}

\item{typeInput}{Type of input methylation data. "beta" for Beta-values and
"M" for M-values}

\item{typeAnalysis}{"M" to use M-values to rank the CpG probes (default).
"beta" to use Beta-values instead}
}
\value{
A named vector containing the t-values from the linear model for each
 CpG probe
}
\description{
Apply a linear model to Illumina's 450k or EPIC methylation data to get the
t-value of each CpG probe
}
\examples{
data(mcseadata)
myRank <- rankProbes(betaTest, phenoTest, refGroup = "Control")
head(myRank)
}
\references{
Smyth, G. K. (2005). \emph{Limma: linear models for microarray
data}. Bioinformatics and Computational Biology Solutions using R and
Bioconductor, 397-420.
}
\seealso{
\code{\link{mCSEATest}}
}
\author{
Jordi Martorell Marugán, \email{jordi.martorell@genyo.es}
}
