% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/query-methods.R
\docType{methods}
\name{query}
\alias{query}
\alias{query,GenomicRanges,list,ANY-method}
\alias{query,list-method}
\alias{query,GenomicRanges,eqtlSet,geneSet-method}
\alias{query,eqtlSet,geneSet-method}
\alias{query,GenomicRanges,list,geneSet-method}
\alias{query,list,geneSet-method}
\title{Query enrichment in geneset through multiple eQTL sets.}
\usage{
query(query.gr, loci, path, ...)

\S4method{query}{GenomicRanges,list,ANY}(query.gr, loci, N = 2897310462)

\S4method{query}{GenomicRanges,eqtlSet,geneSet}(query.gr, loci, path,
  query.score = NULL, verbose = FALSE)

\S4method{query}{GenomicRanges,list,geneSet}(query.gr, loci, path,
  query.score = NULL, parallel = FALSE, verbose = FALSE)
}
\arguments{
\item{query.gr}{a GenomicRange object, representing query regions}

\item{loci}{a list of eqtlSet; each member should be an eqtlSet;
Or it can be a single eqtlSet.}

\item{path}{Pathways or geneSets to be tested for enrichment}

\item{\dots}{additional params}

\item{N}{the total number of non-N nucleotides in the genome;
default N=2897310462 is for hg19}

\item{query.score}{optional, set to NULL if the regions are not ordered.
If the query regions are ordered,  query.score is the quantity based
on which the regions are ordered}

\item{verbose}{bool; whether to show eqtlSet/geneSet summary information;
default is FALSE}

\item{parallel}{bool; whether to enable parallel computing;
default is FALSE}
}
\value{
a data.frame showing the tissue enrichment of the query regions
by binomial test.

a list; \code{result.table} is the major result table showing
enrichment assessment;
 \code{cover.gene} is the vector showing the genes from the eqtl Sets
 covered by the query region(s)

a \code{loci2pathResult} class object
}
\description{
This is the main function for loci2path query. Query can be made
on either pathway enrichment or tissue-specificity, depending on the input
Class. See \strong{Details} for more.
}
\details{
The user need to specify
\enumerate{
    \item Query region; 
    \item loci; one or more eQTL set; this is usually more than one eQTL 
    set. Only multiple eQTL set derived from different cells/tissues will
      show cell/tissue specificity. 
    \item path; pre-defined Pathways, or gene sets. the gene sets that 
 enrichment tests would be performed to.
}

\code{loci} must be provided; \code{path} is optional. When \code{path} is
missing, the tissue-specificity query for the regions is performed.

The most common case for \code{loci} is an eQTL set list.
This function perform enrichment test between one eQTL set and a group of
 gene sets. Usually query are based on eQTL set list, rather than only one
 eQTL set. Several result exploring functions (\code{getMat}, 
 \code{getHeatmap}, \code{getPval}, etc...) are designed for query result 
 from eQTL set list and gene sets. The class \code{loci2pathResult} is also
 designed for eQTL set list query result only. The result returns a
 \code{loci2pathResult} only the class of \code{loci} is a list 
 of \code{eqtlSet}.
 
 If user input one eQTL set as argument \code{loci}, a simple
 list object will be returned for specific research purpose.
}
\examples{
gr.tissue <- query(query.gr, eset.list)
#build one eqtlset
skin.eset <- eset.list$Skin
#query one egset
res.one <- query(query.gr, skin.eset, biocarta)
#enrichment result table
res.one$result.table
#all the genes associated with eQTLs covered by the query region
res.one$cover.gene
result <- query(query.gr=query.gr,
    loci=eset.list, path=biocarta)
#enrichment result table
resultTable(result)
#all the genes associated with eQTLs covered by the query region
coveredGene(result)
}
\seealso{
loci2pathResult
}
