% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_molecules}
\alias{plot_molecules}
\title{Informative plots to investigate individual lipid molecules}
\usage{
plot_molecules(
  data,
  type = c("cv", "sd", "boxplot"),
  measure = "Area",
  log = TRUE,
  color = "Class"
)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{type}{plot type, either \code{cv}, \code{sd} or \code{boxplot}. Default is \code{cv}.}

\item{measure}{Which measure to plot the distribution of: usually Area,
Area Normalized or Height. Default is \code{Area}}

\item{log}{Whether values should be log2 transformed
(Set FALSE for retention time). Default is \code{TRUE}}

\item{color}{The column name of a row annotation to be used as color}
}
\value{
A ggplot object.
}
\description{
\code{lipidr} supports three types of plots for to visualize at lipid molecules.
\cr\cr
\code{cv} plots a bar chart for coefficient of variation of lipid molecules. This
plot type is usually used to investigate the CV in lipid intensity or
retention time, in QC samples. \cr\cr
\code{sd} plots a bar chart for standard deviations of a certain measure in each
lipid. This plot type is usually used to look at standard deviation of
intensity for each lipid, but can also be used to look at different
measures such as \verb{Retention Time}, to ensure all lipids elute within
expected range. \cr\cr
\code{boxplot} plots a boxplot chart to examine the distribution of values per
lipid. This plot type is usually used to look at intensity distribution
for each lipid, but can also be used to look at different measures, such as
\verb{Retention Time} or \code{Background}.
}
\examples{
data(data_normalized)
d_qc <- data_normalized[, data_normalized$group == "QC"]

# plot the variation in intensity and retention time of all measured
#   lipids in QC samples
plot_molecules(d_qc, "cv", "Area")
plot_molecules(d_qc, "cv", "Retention Time", log = FALSE)

# plot the variation in intensity, RT of ISTD (internal standards)
#   in QC samples
d_istd_qc <- data_normalized[
  rowData(data_normalized)$istd,
  data_normalized$group == "QC"
]
plot_molecules(d_istd_qc, "sd", "Area")
plot_molecules(d_istd_qc, "sd", "Retention Time", log = FALSE)

plot_molecules(d_istd_qc, "boxplot")
plot_molecules(d_istd_qc, "boxplot", "Retention Time", log = FALSE)
}
