% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_chain_distribution}
\alias{plot_chain_distribution}
\title{Plot logFC of lipids per class showing chain information}
\usage{
plot_chain_distribution(de_results, contrast = NULL, measure = "logFC")
}
\arguments{
\item{de_results}{Output of \code{\link[=de_analysis]{de_analysis()}}.}

\item{contrast}{Which comparison to plot. if not provided, defaults to the
the first comparison.}

\item{measure}{Which measure to plot the distribution of: logFC, P.Value,
Adj.P.Val. Default is \code{logFC}}
}
\value{
A ggplot object.
}
\description{
Plot a chart of (log2) fold changes of lipids per class showing chain
lengths and unsaturations. If multiple molecules with the same total chain
length and unsaturation are present in the dataset, the \code{measure} is averaged,
and the number of molecules is indicated on the plot.
}
\examples{
data(data_normalized)
de_results <- de_analysis(
  data_normalized,
  HighFat_water - NormalDiet_water,
  measure = "Area"
)
plot_chain_distribution(de_results)
}
