% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mva.R
\name{mva}
\alias{mva}
\alias{plot_mva}
\alias{plot_mva_loadings}
\alias{top_lipids}
\title{Perform multivariate analyses to investigate sample clustering}
\usage{
mva(
  data,
  measure = "Area",
  method = c("PCA", "PCoA", "OPLS", "OPLS-DA"),
  group_col = NULL,
  groups = NULL,
  ...
)

plot_mva(
  mvaresults,
  components = c(1, 2),
  color_by = NULL,
  ellipse = TRUE,
  hotelling = TRUE
)

plot_mva_loadings(
  mvaresults,
  components = c(1, 2),
  color_by = NULL,
  top.n = nrow(mvaresults$loadings)
)

top_lipids(mvaresults, top.n = 10)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{measure}{Which measure to use as intensity, usually Area (default).
The measure should be already summarized and normalized.}

\item{method}{Either PCA, PCoA, OPLS or OPLS-DA.  Default is \code{PCA}.}

\item{group_col}{Sample annotation to use as grouping column. If not
provided, samples are treated independently.}

\item{groups}{A numeric grouping (OPLS) or two groups to be used for
supervised analysis (OPLS-DA), ignored in other methods.}

\item{...}{Extra arguments to be passed to \code{\link[=opls]{opls()}} for OPLS-DA,
ignored in other methods.}

\item{mvaresults}{Results obtained from \code{\link[=mva]{mva()}}.}

\item{components}{Which components to plot. Ignored for PCoA, OPLS and
OPLS-DA results. Default is first 2 components.}

\item{color_by}{Sample annotation (or lipid annotation in case of
\code{plot_mva_loadings}) to use as color. Defaults to individual samples /
lipids}

\item{ellipse}{Whether to plot ellipses around groups}

\item{hotelling}{Whether to plot Hotelling T2.}

\item{top.n}{Number of top ranked features to highlight in the plot.
If omitted, returns top 10 lipids.}
}
\value{
Multivariate analysis results in \code{mvaresults} object.
The object contains the following:\itemize{
\item scores    Sample scores
\item loadings   Feature or component loadings (not for PCoA)
\item method   Multivariate method that was used
\item row_data   Lipid molecule annotations
\item col_data   Sample annotations
\item original_object   Original output object as returned by
corresponding analysis methods
}

\code{plot_mva} returns a ggplot of the sample scores.

\code{plot_mva_loadings} returns a ggplot of the loadings.

\code{top_lipids} returns s dataframe of \code{top.n} lipids with
their annotations.
}
\description{
\code{mva} performs multivariate analysis using several possible methods.
The available methods are PCA, PCoA, OPLS and OPLS-DA. The OPLS method
requires a numeric y-variable, whilst OPLS-DA requires two groups for
comparison. By default, for OPLS and OPLS-DA the number of predictive and
orthogonal components are set to 1.
Blank samples are automatically detected (using TIC) and excluded.
Missing data are imputed using average lipid intensity across all samples.
}
\section{Functions}{
\itemize{
\item \code{plot_mva()}: plots a multivariate scatterplot of sample scores to investigate
sample clustering.

\item \code{plot_mva_loadings()}: Plot a multivariate scatterplot of feature loadings
to investigate feature importance.

\item \code{top_lipids()}: extracts top lipids from OPLS-DA results

}}
\examples{
data(data_normalized)

# PCA
mvaresults <- mva(data_normalized, measure = "Area", method = "PCA")
plot_mva(mvaresults, color_by = "group")
# NOT RUN
# plot_mva(mvaresults, color_by = "Diet", components = c(2, 3))

# PCoA
mvaresults <- mva(data_normalized, measure = "Area", method = "PCoA")
# NOT RUN
# plot_mva(mvaresults, color_by = "group")

# OPLS-DA
mvaresults <- mva(
  data_normalized,
  method = "OPLS-DA", group_col = "Diet", groups = c("HighFat", "Normal")
)
plot_mva(mvaresults, color_by = "group")
plot_mva_loadings(mvaresults, color_by = "Class", top.n = 10)
top_lipids(mvaresults, top.n = 10)
}
