% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/annotate.R
\name{withTxDb}
\alias{withTxDb}
\alias{withTxDb,character,function-method}
\title{Database Operation with Connection Management}
\usage{
withTxDb(x, expr, ...)

\S4method{withTxDb}{character,function}(x, expr, ...)
}
\arguments{
\item{x}{Character string specifying the genome ("hg38", "hg19", or "mm10")}

\item{expr}{Function to execute with database connection}

\item{...}{Additional arguments passed to expr}
}
\value{
Result of the database operation
}
\description{
Executes a database operation while managing the connection lifecycle automatically.
}
\details{
Execute Database Operation with Automatic Connection Management
}
\examples{
\donttest{
# Example 1: Get genes from hg38
result <- withTxDb("hg38", function(src) {
  genes <- Organism.dplyr::genes(src)
  return(head(genes))
})

# Example 2: Get transcripts 
result2 <- withTxDb("hg38", function(src) {
  transcripts <- Organism.dplyr::transcripts(src)
  return(head(transcripts))
})
}
}
