% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{showLinkSet}
\alias{showLinkSet}
\alias{showLinkSet,linkSet-method}
\title{Show linkSet Object Details}
\usage{
showLinkSet(
  object,
  margin = "",
  print.seqinfo = FALSE,
  print.classinfo = FALSE,
  baitRegion = FALSE,
  ...
)

\S4method{showLinkSet}{linkSet}(
  object,
  margin = "",
  print.seqinfo = FALSE,
  print.classinfo = FALSE,
  baitRegion = FALSE
)
}
\arguments{
\item{object}{A linkSet object to display}

\item{margin}{Character string for display margin (default: "")}

\item{print.seqinfo}{Logical, whether to print sequence information (default: FALSE)}

\item{print.classinfo}{Logical, whether to print class information (default: FALSE)}

\item{baitRegion}{Logical, whether to display bait regions (default: FALSE)}

\item{...}{Additional arguments}
}
\value{
None (invisible NULL)
}
\description{
Displays detailed information about a linkSet object, including regions,
metadata, and optionally sequence information.
}
\details{
Display Detailed Information About a linkSet Object
}
\examples{
gr1 <- GRanges(seqnames = c("chr1", "chr2", "chr3"),
               ranges = IRanges(start = c(1000, 2000, 3000), width = 100),
               strand = "+", symbol = c("BRCA1", "TP53", "NONEXISTENT"))
gr2 <- GRanges(seqnames = c("chr1", "chr2", "chr3"),
               ranges = IRanges(start = c(5000, 6000, 7000), width = 100),
               strand = "+")
linkset_obj <- linkSet(gr1, gr2, specificCol = "symbol")
showLinkSet(linkset_obj)
}
