% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{show,linkSet-method}
\alias{show,linkSet-method}
\title{Display detailed information about a linkSet object}
\usage{
\S4method{show}{linkSet}(object)
}
\arguments{
\item{object}{A linkSet object to display}
}
\value{
Invisibly returns NULL. This method is called for its side effect of printing detailed information about the linkSet object to the console.
}
\description{
Display detailed information about a linkSet object
}
\examples{
# Example usage of show method for linkSet object
gr1 <- GRanges(seqnames = c("chr1", "chr2", "chr3"),
               ranges = IRanges(start = c(1000, 2000, 3000), width = 100),
               strand = "+", symbol = c("BRCA1", "TP53", "NONEXISTENT"))
gr2 <- GRanges(seqnames = c("chr1", "chr2", "chr3"),
               ranges = IRanges(start = c(5000, 6000, 7000), width = 100),
               strand = "+")
ls <- linkSet(gr1, gr2, specificCol = "symbol")
show(ls)
}
