% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GRange_method.R
\name{reduceRegions}
\alias{reduceRegions}
\alias{reduceRegions,linkSet-method}
\title{Reduce Regions in a linkSet Object}
\usage{
reduceRegions(x, region = "both", countInteractions = TRUE, ...)

\S4method{reduceRegions}{linkSet}(x, region = "both", countInteractions = TRUE, ...)
}
\arguments{
\item{x}{A linkSet object}

\item{region}{Character, specifying which regions to reduce: "both", "bait", or "oe" (default: "both")}

\item{countInteractions}{Logical, whether to count interactions after reducing (default: TRUE)}

\item{...}{Additional arguments passed to GenomicRanges::reduce}
}
\value{
A reduced linkSet object with the same length as the input
}
\description{
This function reduces the bait and/or oe regions of a linkSet object
and optionally counts interactions, while maintaining the original length of the linkSet.
}
\details{
Reduce a linkSet Object
}
\examples{
data(linkExample)
reduced_linkset <- reduceRegions(linkExample, region = "both", countInteractions = TRUE)
reduced_linkset
}
