% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/visualization.R
\name{geom_linkset}
\alias{geom_linkset}
\alias{geom_linkset,linkSet-method}
\title{Add Genome Links to Coverage Plot}
\usage{
geom_linkset(
  linkSet,
  score.col = "count",
  score.threshold = NULL,
  score.color = c("grey70", "#56B1F7", "#132B43"),
  scale.range = 10,
  plot.space = 0.1,
  plot.height = 0.2,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  link_plot_on_top = FALSE,
  extend.base = 10000,
  show.rect = FALSE,
  x.range = NULL,
  log.scale = TRUE
)

\S4method{geom_linkset}{linkSet}(
  linkSet,
  score.col = "count",
  score.threshold = NULL,
  score.color = c("grey70", "#56B1F7", "#132B43"),
  scale.range = 10,
  plot.space = 0.1,
  plot.height = 0.2,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  link_plot_on_top = FALSE,
  extend.base = 1e+06,
  show.rect = FALSE,
  x.range = NULL,
  log.scale = TRUE
)
}
\arguments{
\item{linkSet}{A linkSet object}

\item{score.col}{Column name containing score information (default: "count")}

\item{score.threshold}{Score threshold for filtering links (default: NULL)}

\item{score.color}{Color vector for score visualization (default: c("grey70", "#56B1F7", "#132B43"))}

\item{scale.range}{Scale factor for link height (default: 10)}

\item{plot.space}{Top and bottom margin (default: 0.1)}

\item{plot.height}{Relative height of link to coverage plot (default: 0.2)}

\item{arrow.size}{Size of arrow heads (default: 0.05)}

\item{remove_x_axis}{Whether to remove x-axis (default: FALSE)}

\item{link_plot_on_top}{Whether to plot links above coverage (default: FALSE)}

\item{extend.base}{Base pair extension range (default: 10000)}

\item{show.rect}{Whether to show rectangle borders (default: FALSE)}

\item{x.range}{Range for x-axis (default: NULL)}

\item{log.scale}{Whether to use log scale for scores (default: TRUE)}
}
\value{
A ggplot layer object
}
\description{
Creates a visualization of genomic links for a linkSet object
}
\details{
Add Genome Links to Coverage Plot
}
\examples{
# Create example linkSet data
gr1 <- GRanges(seqnames = "chr1", 
               ranges = IRanges(start = c(1000, 2000), width = 100),
               strand = "+", symbol = c("Gene1", "Gene2"))
gr2 <- GRanges(seqnames = "chr1", 
               ranges = IRanges(start = c(5000, 6000), width = 100),
               strand = "+")
linkset_obj <- linkSet(gr1, gr2, specificCol = "symbol")

# Add some metadata for visualization
mcols(linkset_obj)$count <- c(10, 20)

# Example plot (requires ggplot2)
\donttest{
library(ggplot2)
p <- ggplot() + geom_linkset(linkset_obj)
print(p)
}
}
