
#' The `glioblastoma_example_data` dataset
#'
#' The dataset is a [`SingleCellExperiment`] object subset to 5,000 cells and
#' 300 genes. The `colData` contain an entry for each cell from which patient
#' it came and to which treatment condition it belonged (`"ctrl"` or `"panobinostat"`).
#'
#' The original data was collected by Zhao et al. (2021).
#'
#' @returns A [`SingleCellExperiment`] object.
#'
#' @references
#' * Zhao, Wenting, Athanassios Dovas, Eleonora Francesca Spinazzi, Hanna Mendes Levitin, Matei Alexandru Banu, Pavan Upadhyayula, Tejaswi Sudhakar, et al.
#'    “Deconvolution of Cell Type-Specific Drug Responses in Human Tumor Tissue with Single-Cell RNA-Seq.” Genome Medicine 13, no. 1
#'    (December 2021): 82. https://doi.org/10.1186/s13073-021-00894-y.
#'
#' @name glioblastoma_example_data
NULL

