% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_in_groups.R
\name{enrichment_in_groups}
\alias{enrichment_in_groups}
\title{enrichment_in_groups}
\usage{
enrichment_in_groups(
  geneset,
  targets = c(),
  background = NULL,
  assay_name = NULL,
  method = "fishers",
  minsize = 5,
  mapping_column = NULL,
  abundance_column = NULL,
  randomize = FALSE,
  silence_try_errors = TRUE
)
}
\arguments{
\item{geneset}{geneset to use for enrichment}

\item{targets}{targets to use for enrichment}

\item{background}{`SummarizedExperiment` describing background to use}

\item{assay_name}{is the name of the assay to use from the background}

\item{method}{method to use for statistical test, options are
'fishers' or 'ks'. NOTE: if you do not call `suppressWarnings` then
the KS test will warn you about ties.}

\item{minsize}{minimum size of set}

\item{mapping_column}{column name of mapping identifiers}

\item{abundance_column}{columns mapping abundance, either in the `assay`
matrix or `rowData`}

\item{randomize}{true/false whether to randomize}

\item{silence_try_errors}{true/false to silence errors}
}
\value{
data frame with enrichment results
}
\description{
Calculate the enrichment in pathways using Fisher's exact or
Kolmogorov-Smirnov test, using either the abundance column to identify
feature or the targets list. access through leapr wrapper
}
