% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_in_abundance.R
\name{enrichment_in_abundance}
\alias{enrichment_in_abundance}
\title{enrichment_in_abundance}
\usage{
enrichment_in_abundance(
  geneset,
  eset,
  assay_name,
  mapping_column = NULL,
  abundance_column = NULL,
  fdr = 0,
  matchset = NULL,
  sample_comparison = NULL,
  min_p_threshold = NULL,
  sample_n = NULL,
  silence_try_errors = TRUE
)
}
\arguments{
\item{geneset}{Gene set to calculate enrichment}

\item{eset}{Molecular abundance data in `SummarizedExperiment` format}

\item{assay_name}{Name of assay to compare}

\item{mapping_column}{Column to use to map identifiers}

\item{abundance_column}{Columns to use to quantify abundance}

\item{fdr}{number of times to sample for FDR value}

\item{matchset}{Name of a set to use for enrichment}

\item{sample_comparison}{list of samples to use as comparison. if missing
background (eset) is used}

\item{min_p_threshold}{Only include p-values lower than this}

\item{sample_n}{size of sample to use}

\item{silence_try_errors}{set to true to silence try errors}
}
\value{
data frame of enrichment result
}
\description{
Enrichment in abundance calculates enrichment in pathways by the difference
in abundance of the pathway members.
}
