% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTTest.R
\name{calcTTest}
\alias{calcTTest}
\title{calcTTest}
\usage{
calcTTest(eset, assay_name, group1, group2)
}
\arguments{
\item{eset}{SummarizedExperiment}

\item{assay_name}{name of assay}

\item{group1}{List of samples comprising group 1}

\item{group2}{List of samples comprising group 2}
}
\value{
An Expression set with two columns added to the featureData
slot: pvalue, and estimate
}
\description{
calculates a t-test for two distributions of data on a per-gene basis
append results to ExpressionSet with two extra columns: `pvalue` and
`difference` for each feature
}
\examples{

        library(leapR)
        url <- "https://api.figshare.com/v2/file/download/56536214"
        tdata <- download.file(url,method='libcurl',destfile='transData.rda')
        load('transData.rda')
        p <- file.remove("transData.rda")

        # read in the pathways
        data("ncipid")

        # read in the patient groups
        data("shortlist")
        data("longlist")
        calcTTest(tset, 'transcriptomics', shortlist, longlist)
}
