% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_1kg.R
\name{s3_1kg}
\alias{s3_1kg}
\title{Create a URL referencing 1000 genomes content in AWS S3.
stack1kg produces a VcfStack instance with references to VCF for 1000
genomes autosomal chrs.  S3-resident VCF files with version "v5a.20130502"
are used.}
\usage{
s3_1kg(chrnum, tmpl, dropchr = TRUE)
}
\arguments{
\item{chrnum}{a character string denoting a chromosome, such as '22'}

\item{tmpl}{alternate template for full URL, useful if versions prior to
2010 are of interest}

\item{dropchr}{if TRUE \code{chrnum} will have 'chr' removed if present}
}
\value{
by default, a TabixFile instance
}
\description{
Create a URL referencing 1000 genomes content in AWS S3.
stack1kg produces a VcfStack instance with references to VCF for 1000
genomes autosomal chrs.  S3-resident VCF files with version "v5a.20130502"
are used.
}
\note{
The "wrap" parameter has been removed.  A TabixFile structure will be returned.  The
tag parameter has been removed.  Supply a tmpl argument if you are not using 20130502 version.
}
\examples{
requireNamespace("Rsamtools")
s3_1kg("22") # try scanVcfHeader from VariantAnnotation
}
\keyword{models}
