% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmoptpermcut.R
\name{km_opt_pcut}
\alias{km_opt_pcut}
\title{Find and evaluate optimal stratification cutoffs}
\usage{
km_opt_pcut(
  obj,
  bfname,
  wdir = getwd(),
  min_fraction = 0.1,
  min_up_down = 1,
  n_iter = 100,
  peak_tolerance = 0.1,
  psort = FALSE,
  min_uval = 50,
  wlabels = TRUE,
  wpdf = TRUE,
  verbose = TRUE,
  nproc = 1
)
}
\arguments{
\item{obj}{SummarizedExperiment object with expression-like data}

\item{bfname}{a character string (character vector of length 1) that
specifies the base name used to construct output files, which are  
created by adding\cr'KMoptp_minf_.2f_iter_d' and corresponding
extension to 'bfname'.}

\item{wdir}{a character string (character vector of length 1) that 
specifies the name of the working directory for the output files 
(defaults to the current R directory).}

\item{min_fraction}{numeric value that specifies the minimal fraction of
samples in the smaller group (default is 0.1).}

\item{min_up_down}{numeric value that specifies the minimal number of
up/down points on either side of the peak for
pracma::findpeaks function (default is 1).}

\item{n_iter}{numeric value that specifies the number of iterations
for the permutation test.
The default is n_iter=100 for fast calculations. Recommended
is n_iter=10000 (slow, especially for a large number of samples/features).}

\item{peak_tolerance}{numeric value that specifies the maximal difference
in height between top peaks.
The peak within 'peak_tolerance' closest to the median value is selected.}

\item{psort}{logical value whether to sort the output table by p-values
in increasing order (default is FALSE).}

\item{min_uval}{numeric value that specifies the minimal percentage of
unique values per feature (default is 50).
Features that have less than 'min_uval' percent unique values are
excluded from the analysis.}

\item{wlabels}{logical value whether to write a CSV file with low/high
(below/above the cutoff) group sample labels (default is TRUE).}

\item{wpdf}{logical value whether to write a PDF file with plots
(default is TRUE).}

\item{verbose}{logical value whether to print progress (default is TRUE).}

\item{nproc}{integer value that specifies the number of logical processors
(default is 1, meaning execute sequentially).}
}
\value{
no return value
}
\description{
For each feature, finds a cutoff that optimally stratifies samples
into 2 groups, plots Kaplan-Meier survival curves and observed vs. expected
optimization plot. Then, performs the permutation test to estimate
the statistical significance of the cutoff.
}
\examples{

# Example with data files included in the package:

# Load example gene expression data and survival data for 2 genes
# and 93 samples:
fdat <- system.file("extdata", "example_genes.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

#' # Create SummarizedExperiment object
se <- create_se_object(efile = fdat, sfile = sdat)

# Search for optimal cutoffs and run the permutation tests on 1 CPU
km_opt_pcut(obj = se, bfname = "test", wpdf = FALSE, n_iter = 10)

# This will create two output files in the current R working directory:
# 1) Tab-delimited text file with the results:
# "test_KMoptp_minf_0.10_iter_10.txt"
# 2) CSV file with low/high sample labels:
# "test_KMoptp_minf_0.10_iter_10_labels.csv"
}
