% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R
\docType{methods}
\name{ModelSelectionResultAccessors}
\alias{ModelSelectionResultAccessors}
\alias{fullModel}
\alias{fullModel,ModelSelectionResult-method}
\alias{gridColumns}
\alias{gridColumns,ModelSelectionResult-method}
\alias{gridErrors}
\alias{gridErrors,ModelSelectionResult-method}
\alias{gridRows}
\alias{gridRows,ModelSelectionResult-method}
\alias{performance}
\alias{performance,ModelSelectionResult-method}
\alias{selGridCol}
\alias{selGridCol,ModelSelectionResult-method}
\alias{selGridRow}
\alias{selGridRow,ModelSelectionResult-method}
\title{ModelSelectionResult Accessors}
\usage{
\S4method{gridRows}{ModelSelectionResult}(object)
}
\arguments{
\item{object}{a model selection result object (can be extracted from
KeBABS model with accessor \code{\link{modelSelResult}})}
}
\value{
\code{gridRows}: returns a list of kernel objects\cr
\code{gridColumns}: returns a \code{DataFrame} object with grid column
parameters\cr
\code{gridErrors}: returns a matrix with grid errors\cr
\code{performance}: returns a list of matrices with performance values
\code{selGridRow}: returns the selected kernel
\code{selGridCol}: returns the selected SVM and/or hyperparameter(s)
\code{fullModel}: returns a kebabs model of class
\code{\linkS4class{KBModel}}
}
\description{
ModelSelectionResult Accessors
}
\section{Accessor-like methods}{

  In all descriptions below, \code{object} is an object of class
  \code{\linkS4class{ModelSelectionResult}}.

\describe{
  \item{\code{gridRows(object)}}{
  returns the grid rows containing the kernels.
  }
  \item{\code{gridColumns(object)}}{
  returns the grid columns.
  }
  \item{\code{gridErrors(object)}}{
  returns the grid CV errors.
  }
  \item{\code{performance(object)}}{
  return the collected performance parameters.
  }
  \item{\code{selGridRow(object)}}{
  returns the selected grid row.
  }
  \item{\code{selGridCol(object)}}{
  returns the selected grid column.
  }
  \item{\code{fullModel(object)}}{
  returns the full model.
  }
}
}
\examples{
## create kernel object for normalized spectrum kernel
specK5 <- spectrumKernel(k=5)
\dontrun{
## load data
data(TFBS)

## perform training - feature weights are computed by default
model <- kbsvm(enhancerFB, yFB, specK5, pkg="LiblineaR",
               svm="C-svc", cost=c(1,15,50,100), cross=10,
               perfParameters="ALL", showProgress=TRUE)

## show model selection result
mres <- modelSelResult(model)
mres

## extract grid errors
gridErrors(mres)

## extract other performance parameters
performance(mres)
}
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
