% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R
\docType{methods}
\name{CrossValidationResultAccessors}
\alias{CrossValidationResultAccessors}
\alias{folds}
\alias{folds,CrossValidationResult-method}
\alias{performance,CrossValidationResult-method}
\title{CrossValidationResult Accessors}
\usage{
\S4method{folds}{CrossValidationResult}(object)
}
\arguments{
\item{object}{a cross validation result object (can be extracted from
KeBABS model with accessor \code{\link{cvResult}})}
}
\value{
\code{folds}: returns the folds used in CV\cr
\code{performance}: returns a list with the performance values
}
\description{
CrossValidationResult Accessors
}
\section{Accessor-like methods}{


\describe{
  \item{\code{folds}}{
    returns the CV folds.
  }
  \item{\code{performance}}{
    returns the collected performance parameters.
  }
}
}
\examples{
## create kernel object for normalized spectrum kernel
specK5 <- spectrumKernel(k=5)
\dontrun{
## load data
data(TFBS)

## perform training - feature weights are computed by default
model <- kbsvm(enhancerFB, yFB, specK5, pkg="LiblineaR",
               svm="C-svc", cross=10, cost=15, perfParameters="ALL")

## show model selection result
cvResult(model)

## extract fold AUC
performance(cvResult(model))$foldAUC
}
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

