% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotGenes.R
\name{kpPlotGenes}
\alias{kpPlotGenes}
\title{kpPlotGenes}
\usage{
kpPlotGenes(karyoplot, data, gene.margin=0.3, gene.col=NULL, gene.border.col=NULL,
                       add.gene.names=TRUE, gene.names=NULL, gene.name.position="top", gene.name.cex=1, gene.name.col=NULL,
                       plot.transcripts=TRUE, transcript.margin=0.5, transcript.col=NULL, transcript.border.col=NULL,
                       add.transcript.names=FALSE, transcript.names=NULL, transcript.name.position="left", transcript.name.cex=0.6, transcript.name.col=NULL,
                       plot.transcripts.structure=TRUE,
                       non.coding.exons.height=0.5, 
                       add.strand.marks=TRUE, mark.height=0.20, mark.width=1, mark.distance=4,
                       coding.exons.col=NULL, coding.exons.border.col=NULL, 
                       non.coding.exons.col=NULL, non.coding.exons.border.col=NULL, 
                       introns.col=NULL, marks.col=NULL,
                       data.panel=1, r0=NULL, r1=NULL, col="black", 
                       border=NULL, avoid.overlapping=TRUE, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{TxDb} object or a list with the required elements) A \code{TxDb} object with information on genes, transcripts and exons and their position on the genome.}

\item{gene.margin}{(numeric) If whole genes (as oposed to transcripts) are plotted (\code{plot.transcripts=FALSE}), the vertical margin between overlapping genes. The value is with respect to the gene height. A value of 0.5 will create a space above the genes with half the height of the genes themselves. (defaults to 0.3)}

\item{gene.col}{(color) If whole genes (as oposed to transcripts) are plotted (\code{plot.transcripts=FALSE}), the color used to fill the rectangles representing the genes. If NULL, the value of \code{col} will be used. (Defaults to NULL)}

\item{gene.border.col}{(color) If whole genes (as oposed to transcripts) are plotted (\code{plot.transcripts=FALSE}), the color used in the border of the rectangles representing the genes. If NULL, the value of \code{col} will be used. If NA, no border is drawn. (Defaults to NULL)}

\item{add.gene.names}{(boolean) Whether to add the names of the genes to the plot.}

\item{gene.names}{(named character vector) A named character vector with the labels of the genes. If not NULL, it will be used as a dictionary, so gene ids should be names and desired labels the values. If NULL, if genes.data$genes$name exists, it will use it, otherwise it will use the mcols(genes.data$genes)[,1] as labels. (defaults to NULL)}

\item{gene.name.position}{(character) The position of the gene name text relative to the rectangle. Can be "left", "right", "top", "bottom" or "center". (Defaults to "top")}

\item{gene.name.cex}{(numeric) The cex value to plot the gene names (defaults to 1)}

\item{gene.name.col}{(color) The color of the gene labels. If NULL, it will use col. (defaults to NULL)}

\item{plot.transcripts}{(boolean) Whether to plot the individual transcripts (TRUE) or a single rectangle to represent the whole gene (FALSE). (Defaults to TRUE)}

\item{transcript.margin}{(numeric) If transcripts are plotted (\code{plot.transcripts=TRUE}), the vertical margin between overlapping transcripts. The value is with respect to the transcript height. A value of 0.5 will create a space above the transcripts with half the height of the transcripts themselves. (defaults to 0.5)}

\item{transcript.col}{(color) If transcripts are plotted (\code{plot.transcripts=TRUE}), the color used to fill the rectangles representing the transcripts. If NULL, the value of \code{col} will be used. (Defaults to NULL)}

\item{transcript.border.col}{(color) If transcripts are plotted (\code{plot.transcripts=TRUE}), the color used in the border the rectangles representing the transcripts. If NULL, the value of \code{col} will be used. If NA, no border will be drawn. (Defaults to NULL)}

\item{add.transcript.names}{(boolean) Whether to add the names of the tramscripts to the plot. (defaults to FALSE)}

\item{transcript.names}{(named character) A named character vector with the labels of the transcripts. If not null, it will be used as a dictionary, so transcript ids should be names and desired labels the values. If NULL, the transcript ids will be used as labels. (defaults to null)}

\item{transcript.name.position}{(character) The position of the transcript name text relative to the rectangle. Can be "left", "right", "top", "bottom" or "center". (Defaults to "left")}

\item{transcript.name.cex}{(numeric) The cex value to plot the transcript names (defaults to 0.6)}

\item{transcript.name.col}{(color) The color of the transcript labels. If NULL, it will use col. (defaults to NULL)}

\item{plot.transcripts.structure}{(boolean) Whether to draw the transcripts as single rectangles (FALSE) or to show the complete transcript structure (introns and exons) (TRUE). (Defaults to TRUE)}

\item{non.coding.exons.height}{(numeric) The height of the non.coding exons relative to the transcript height. For example, if 0.5, non-coding exons will have a height half the size of the coding ones. (default 0.5)}

\item{add.strand.marks}{(boolean) Whether strand marks should be plotted or not. Strand marks are small arrows along the introns (or whole transcripts if plot.transcript.structure=FALSE). (defaults to TRUE)}

\item{mark.height}{(numeric) The height of the strand marks in "coding exons heights", that is, if mark.height is 0.5, the mark will have a height of half the height of an exon. (defaults to 0.2)}

\item{mark.width}{(numeric) The width of the strand marks, in mark heights. mark.width=1 will produce arrow heads with a slope pf 45 degrees. A value higher than 1 will produce smaller angles and a value below 1 larger angles with more vertical lines. (defaults to 1, 45 degrees)}

\item{mark.distance}{(numeric) The distance between marks, in mark widths. A distance of 2, will add a space of 2*mark.width between consecutive marks. (defaults to 4)}

\item{coding.exons.col}{(color) The fill color of the rectangles representing the coding exons. If NULL, it will use col. (defaults to NULL)}

\item{coding.exons.border.col}{(color) The color of the border of the coding exons. If NULL, it will use border. (defaults to NULL)}

\item{non.coding.exons.col}{(color) The fill color of the rectangles representing the non-coding exons. If NULL, it will use col. (defaults to NULL)}

\item{non.coding.exons.border.col}{(color) The color of the border of the non-coding exons. If NULL, it will use border. (defaults to NULL)}

\item{introns.col}{(color) The color of the lines representing the introns. If NULL, it will use col. (defaults to NULL)}

\item{marks.col}{(color) The color of the arrows representing the strand. If NULL, it will use col. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{col}{(color) The color of the genes, transcripts and labels. It is possible to specify different colors for each element class (transcript names, exons, strand marks...). All elements with no explicit color will be plotted using col. (Defaults to "black")}

\item{border}{(color) The color of the border of rectangles representing genes, transcripts and exons. Every element class may have its own specific color using the appropiate parameters. The ones with no explicit color will use border. At the same time, if border is NULL, it will default to col. (Defaults to NULL)}

\item{avoid.overlapping}{(boolean) If two or more regions (genes, transcripts) overlap in the genome (even partially), they can be drawn in two different layers (TRUE) or in the same layer, with superposing representations (FALSE). (Defaults to TRUE, draw non-overlapping elements)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plot genes and transcripts in the genome. Can get the genes and trancripts information from TxDb or from custom objects.
}
\details{
This is one of karyoploteR's higher level functions. It takes a transcript 
 database (\code{TxDb}) object or a custom object with a specific structure 
 and plots the genes along the genome. It's possible to plot genes as 
 a whole using rectangle for each gene or to plot each transcript 
 independently. If transcripts are drawn, it's possible to plot them as
 single boxes or to plot the detailed structure, differentiating 
 coding exons, non-coding exons and introns. Transcripts may have, in 
 addition, little arrows to mark the trascript strand (plus or minus). These
 strand marks are plotted in introns if the transcript structure is shown 
 or on the whole transcript length if transcripts are plotted as boxes. 
 Finally, it's possible to add labels to genes and transcripts. By default 
 genes and transcripts identifiers in the input data structure will be used
 as labels, but it's possible to provide named character vectors to be 
 used as dictionaries to change id's to better names.
   
 The genes and transcripts representations are customizable. It's possible
 to change the colors of the different elements individually (i.e. to 
 have red coding exons, blue non-coding exons and green introns); it's 
 possible to change the relative height of the non-coding exons and to 
 change the slate and density of the strand marks.
 
 The data stating the positions of genes, transcripts and exons in the 
 genome and their relations (which transcripts belong to which genes) 
 can be given as a standard transcript database (\code{TxDb}) object or
 as a custom list with the following elements: \code{genes},
 \code{transcripts}, \code{coding.exons} and \code{non.coding.exons}.
}
\note{
Plotting transcripts, specially plotting their structure might get 
quite slow in comparison to the usual speed of plotting in karyoploteR. It
is not advised to plot genes and transcripts on the whole genome or in 
large regions of it. These functions have been designed to work with
zoomed in karyoplots.
}
\examples{
 
 
 library(TxDb.Hsapiens.UCSC.hg19.knownGene)
 txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
 
 zoom <- toGRanges("chr2", 47986268, 48147403)
 gene.names <- c("2956"="MSH6", "80204"="FBXO11")
 
 kp <- plotKaryotype(genome="hg19", zoom=zoom)
 kpPlotGenes(kp, data=txdb, add.transcript.names = FALSE, gene.names=gene.names, r1=0.6)

 kp <- plotKaryotype(genome="hg19", zoom=zoom)
 kpPlotGenes(kp, data=txdb, plot.transcripts=FALSE, gene.names=gene.names, r1=0.6)

 kp <- plotKaryotype(genome="hg19", zoom=zoom)
 kpPlotGenes(kp, data=txdb, plot.transcripts.structure=FALSE, add.transcript.names=FALSE, gene.names=gene.names, r1=0.8, col="blue", marks.col="white", gene.name.col="black")
 
 library(TxDb.Mmusculus.UCSC.mm10.knownGene)
 kp <- plotKaryotype(genome="mm10", zoom="chr1:10.5e6-12.5e6")
 genes.data <- makeGenesDataFromTxDb(txdb=TxDb.Mmusculus.UCSC.mm10.knownGene, karyoplot=kp)
 genes.data <- addGeneNames(genes.data)
 genes.data <- mergeTranscripts(genes.data)
 kpPlotGenes(kp, genes.data, r1=0.25, mark.height = 0.5, gene.name.position = "left")
 
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpRect}}, \code{\link{kpSegments}}, \code{\link{kpPlotTranscripts}}
}
