% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotCoverage.R
\name{kpPlotCoverage}
\alias{kpPlotCoverage}
\title{kpPlotCoverage}
\usage{
kpPlotCoverage(karyoplot, data, show.0.cov=TRUE, data.panel=1, r0=NULL, r1=NULL, col="#0e87eb", border=NULL, ymax=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges} or a coverage object) A GRanges object from wich the coverage will be computed or a \code{SimpleRleList} result of computing the coverage.}

\item{show.0.cov}{(boolean) Wether to plot a thin line representing the regions with no coverage at all. (defaults to TRUE, plot the line)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{col}{(color) The background color of the regions. (defaults to "#0e87eb")}

\item{border}{(color) The color of the border used to plot the coverage. If NULL, NA (no border) is used. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value to be plotted on the data.panel. If NULL the maximum coverage is used. (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object with the data computed (max.coverage, ymax) stored in latest.plot.
}
\description{
Given a \code{GRanges} object, plot the coverage along the genome.
}
\details{
This is one of the high-level, or specialized, plotting functions of karyoploteR.
 It takes a \code{GRanges} object and plots it's coverage, that is, the number of regions
 overlapping each genomic position. The input can also be a \code{SimpleRleList} resulting
 from computing the coverage with \code{coverage(data)}. In contrast with the low-level 
 functions such as \code{\link{kpRect}}, it is not possible to specify the data using 
 independent numeric vectors and the function only takes in the expected object types.
 
 There's more information at the \url{https://bernatgel.github.io/karyoploter_tutorial/}{karyoploteR tutorial}.
}
\examples{
 
 set.seed(1000)
 
 #Example 2: Do the same with a single bigger set of possibly overlapping regions
 
 kp <- plotKaryotype("hg19", plot.type=1, chromosomes=c("chr1", "chr2"))
 
 regs <- createRandomRegions(nregions = 1000, length.mean = 10000000, length.sd = 1000000,
                             non.overlapping = FALSE, genome = "hg19", mask=NA)
 kpPlotRegions(kp, regs, r0 = 0, r1 = 0.8, col="#AAAAAA")
 
 kpPlotCoverage(kp, regs, ymax = 20, r0=0.8,  r1=1, col="#CCCCFF")
 kpAxis(kp, ymin = 0, ymax= 20, numticks = 2, r0 = 0.8, r1=1)
 
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpPlotRegions}}, \code{\link{kpBars}},  \code{\link{kpPlotBAMCoverage}}, \code{\link{kpPlotDensity}}
}
