% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddCytobandsAsLine.R
\name{kpAddCytobandsAsLine}
\alias{kpAddCytobandsAsLine}
\title{kpAddCytobandsAsLine}
\usage{
kpAddCytobandsAsLine(karyoplot, color.table=NULL, color.schema='only.centromeres', lwd=3, lend=1, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{color.table}{(named character vector) a table specifying the colors to plot the cytobands. If NULL, it gets the colors calling \code{getCytobandColors}. (defaults to NULL)}

\item{color.schema}{(character: 'only.centromeres', 'circos', 'biovizbase') The name of the color schema to use. It is directly passed along to \code{\link{getCytobandColors}}. \code{color.table} takes precendence over \code{color.schema}. (defaults to 'only.centromeres')}

\item{lwd}{(integer) The width of the line used to represent the ideogram (defaults to 3)}

\item{lend}{(0, 1 or 2) The type of line end. (defaults to 1, "butt")}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, cytoband representation will be not drawn out of the drawing are (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the cytobands representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{any additional parameter to be passed to the functions called from kpAddCytobands.}
}
\value{
invisibly returns the given karyoplot object
}
\description{
Plots the chromosome cytobands in a karyoplot as a line
}
\details{
Plots the cytobands representing the chromosome structure in a karyoplot. It extracts the 
cytobands from the \code{karyoplot} object it recieves as a parameter. It is possible to 
specify the colors used to plot the cytobands. In contrast to \code{\link{kpAddCytobands}}
it represents the chromosomes as a thin line
}
\note{
In general, this function is automatically called by plotKaryotype
and the user never needs to call it.
}
\examples{


kp <- plotKaryotype(ideogram.plotter = NULL)
kpAddCytobandsAsLine(kp)
 
kp <- plotKaryotype(ideogram.plotter = NULL, plot.type=2)
kpAddCytobandsAsLine(kp)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{getCytobandColors}}, \code{\link{kpAddBaseNumbers}}, \code{\link{kpAddCytobandLabels}}
}
