% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddCytobands.R
\name{kpAddCytobands}
\alias{kpAddCytobands}
\title{kpAddCytobands}
\usage{
kpAddCytobands(karyoplot, color.table=NULL, color.schema=c("circos", "biovizbase", "only.centromeres"), clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{color.table}{(named character vector) a table specifying the colors to plot the cytobands. If NULL, it gets the colors calling \code{getCytobandColors}. (defaults to NULL)}

\item{color.schema}{(character) The name of the color schema to use: \code{circos}, \code{biovizBase}, \code{only.centromeres} (everything in gray, except for centromeres in red). (defaults to \code{circos})}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, cytoband representation will be not drawn out of the drawing are (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the cytobands representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{any additional parameter to be passed to the functions called from kpAddCytobands.}
}
\value{
invisibly returns the given karyoplot object
}
\description{
Plots the chromosome cytobands in a karyoplot
}
\details{
Plots the cytobands representing the chromosome structure in a karyoplot. It extracts the 
cytobands from the \code{karyoplot} object it recieves as a parameter. It is possible to 
specify the colors used to plot the cytobands.
}
\note{
In general, this function is automatically called by plotKaryotype
and the user never nees to call it.
}
\examples{


kp <- plotKaryotype(ideogram.plotter = NULL)
kpAddCytobands(kp)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{getCytobandColors}}, \code{\link{kpAddBaseNumbers}}, \code{\link{kpAddCytobandLabels}}
}
