% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{horizonColors}
\alias{horizonColors}
\title{horizonColors}
\usage{
horizonColors(col, num.parts)
}
\arguments{
\item{col}{(array of colors) An array of colors}

\item{num.parts}{(positive integer) The number of colors to generate for pos and neg}
}
\value{
A list with 2 elements, pos and neg, each with num.parts colors
}
\description{
Returns the color structure needed by kpPlotHorizon
}
\details{
This function transforms an array of colors into a list of colors 
**internally** needed by kpPlotHorizon: a list with two elements, "neg" 
and "pos", each an array of colors of length num.parts. If col is 
a character of length one, it is interpreted as the name of a color scheme.


horizonColors(col, num.parts)
}
\examples{
 
horizonColors("redblue6", 3)
horizonColors("redblue6", 6)
horizonColors("bluegold3", 2)
horizonColors(c("red", "blue"), 3)
horizonColors(c("red", "#FFFFFF00", "blue"), 3)
 
}
