% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChromosomeNamesBoundingBox.R
\name{getChromosomeNamesBoundingBox}
\alias{getChromosomeNamesBoundingBox}
\title{getChromosomeNamesBoundingBox}
\usage{
getChromosomeNamesBoundingBox(karyoplot)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}
}
\value{
Returns a list with four elements (x0, x1, y0 and y1), each of them a named
vector of integers with one coordinatefor every chromosome in the plot.
}
\description{
Return the regions where the chromosome names should be placed
}
\details{
Given a KaryoPlot object, return the regions where the chromosome labels 
should be placed. The positions will depend on the plot type used.
}
\note{
In general, this function is automatically called by karyoploteR
and the user never needs to call it.
}
\examples{

kp <- plotKaryotype()
bb <- getChromosomeNamesBoundingBox(kp)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpAddChromosomeNames}}
}
