% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vectors.R
\name{.get_gene_vectors_tr}
\alias{.get_gene_vectors_tr}
\title{Create spatial vectors for genes from transcript coordinates}
\usage{
.get_gene_vectors_tr(
  trans_lst,
  test_genes,
  bin_type,
  bin_param,
  bin_length,
  range_list
)
}
\arguments{
\item{trans_lst}{If specified, it is a list of named dataframes. 
Each dataframe refers to one sample and shows the transcript detection 
coordinates for each gene. Optional parameter.}

\item{test_genes}{A vector of strings giving the name of the genes you 
want to test. This will be used as column names for one of the result matrix
\code{gene_mt}.}

\item{bin_type}{A string indicating which bin shape is to be used for
vectorization. One of "square" (default), "rectangle", or "hexagon".}

\item{bin_param}{A numeric vector indicating the size of the bin. If the
\code{bin_type} is "square" or "rectangle", this will be a vector of length
two giving the numbers of rectangular quadrats in the x and y directions. If
the \code{bin_type} is "hexagonal", this will be a number giving the side
length of hexagons. Positive numbers only.

For example:
  \itemize{
    \item \code{c(3, 4)} means 3 bins along the x-axis and 4 bins
      along the y-axis (a 3 × 4 grid).
    \item \code{c(5, 5)} means 5 bins along the x-axis and 5 bins
      along the y-axis (a 5 × 5 grid).
  }}

\item{bin_length}{A positive integer giving the length of total bins}

\item{range_list}{A named list of spatial ranges for each sample. 
Each element should be a list with two components:
\code{w_x} and \code{w_y}, which are numeric vectors of length 2 
specifying the x- and y-axis ranges (e.g., from cell or 
transcript coordinates).
The range is calculated with 5% buffer to ensure all points fall 
within the window.}
}
\value{
a matrix contains the transcript count in each grid.
Each row refers to a grid, and each column refers to a gene.
}
\description{
This function will build gene vectors based on the transcript coordinates of
every gene
}
