% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_markers.R
\name{.check_valid_input}
\alias{.check_valid_input}
\title{helper function to check the inputs passed to marker detection function}
\usage{
.check_valid_input(
  gene_mt,
  cluster_mt,
  sample_names,
  n_fold = 10,
  background = NULL
)
}
\arguments{
\item{gene_mt}{A matrix contains the transcript count in each grid.
Each row refers to a grid, and each column refers to a gene.
The column names must be specified and refer to the genes. This can be the
output from the function \code{\link{get_vectors}}.}

\item{cluster_mt}{A matrix contains the number of cells in a specific
cluster in each grid. Each row refers to a grid, and each column
refers to a cluster. The column names must be specified and refer to the
clusters. Please do not assign integers as column names.
This can be the output from the function \code{\link{get_vectors}}.}

\item{sample_names}{A vector specifying the names for the samples.}

\item{n_fold}{Optional. A positive number giving the number of folds used
for cross validation. This parameter will pass to 
\code{\link[glmnet]{cv.glmnet}} to calculate a penalty term for every gene.}

\item{background}{Optional. A matrix providing the
background information. Each row refers to a grid, and each column refers to
one category of background information. Number of rows must equal to the
number of rows in \code{gene_mt} and \code{cluster_mt}.
Can be obtained by only providing coordinates matrices \code{cluster_info}.
to function \code{get_vectors}.}
}
\value{
a list of two matrices with the following components
\item{\code{n_clusters} }{ Number of clusters}
\item{\code{cluster_names} }{a vector of strings giving the name
of the clusters }
}
\description{
helper function to check the inputs passed to marker detection function
}
