% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomiRs.R
\name{isoNorm}
\alias{isoNorm}
\title{Normalize count matrix}
\usage{
isoNorm(ids, formula = NULL, maxSamples = 50)
}
\arguments{
\item{ids}{Object of class \link{IsomirDataSeq}.}

\item{formula}{Formula that will be used for normalization.}

\item{maxSamples}{Maximum number of samples to use with
\code{\link[DESeq2:rlog]{DESeq2::rlog()}}, if not \code{\link[limma:voom]{limma::voom()}} is used.}
}
\value{
\link{IsomirDataSeq} object with the normalized
count matrix in a slot. The normalized matrix
can be access with \code{counts(ids, norm=TRUE)}.
}
\description{
This function normalizes raw count matrix using
\code{\link[DESeq2:rlog]{DESeq2::rlog()}} function from \link[DESeq2:DESeq2-package]{DESeq2::DESeq2-package}.
}
\examples{
data(mirData)
ids <- isoCounts(mirData, minc=10, mins=6)
ids <- isoNorm(mirData, formula=~condition)
head(counts(ids, norm=TRUE))
}
