% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Cpp_summarize_regions}
\alias{Cpp_summarize_regions}
\title{Apply a function over BED file records within genomic features}
\usage{
Cpp_summarize_regions(
  bedfiles,
  regions,
  fun_vec,
  col_indices,
  col_names,
  aligner,
  mval = FALSE,
  region_rownames = FALSE,
  nthreads = 1L
)
}
\arguments{
\item{bedfiles}{A vector of BED file paths}

\item{regions}{A vector of genomic regions}

\item{fun_vec}{Vector of the armadillo-supported stats functions to apply over the
CpGs in the ' regions: \code{"sum"}, \code{"mean"}, \code{"median"}, \code{"stddev"},
\code{"variance"} "\code{count}", \code{"min"},\code{"max"}, and \code{"range"}.}

\item{col_indices}{A vector of genomic regions}

\item{col_names}{A vector of genomic regions}

\item{mval}{Calculates M values when TRUE, use beta values when FALSE}

\item{region_rownames}{Whether to set rownames to the regions strings. Not
necessary if your regions vector is unnamed. If its names, then the "feature"
column is set to the names and the rownames are set to the regions string}

\item{nthreads}{Number of cores to use. See details.}
}
\value{
A summary data.frame
}
\description{
This function should be called from \code{summarize_regions()} since there are few
sanity checks on the C++ side.
}
\details{
The optimal number of threads depends on the number of bedfiles, but is set
to half the available OpenMP cores. See \code{?get_threads} for more details. It
can be manaully set with \code{set_threads()}.
}
\keyword{internal}
