# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

decode_beta <- function(encoded) {
    .Call(`_iscream_decode_beta`, encoded)
}

decode_cov <- function(encoded) {
    .Call(`_iscream_decode_cov`, encoded)
}

get_cov <- function(m, nthreads) {
    invisible(.Call(`_iscream_get_cov`, m, nthreads))
}

get_m <- function(m, nthreads) {
    invisible(.Call(`_iscream_get_m`, m, nthreads))
}

get_beta <- function(m, nthreads) {
    invisible(.Call(`_iscream_get_beta`, m, nthreads))
}

get_cov_sparse <- function(m) {
    invisible(.Call(`_iscream_get_cov_sparse`, m))
}

get_m_sparse <- function(m) {
    invisible(.Call(`_iscream_get_m_sparse`, m))
}

get_beta_sparse <- function(m) {
    invisible(.Call(`_iscream_get_beta_sparse`, m))
}

get_omp_threads <- function(verbose) {
    .Call(`_iscream_get_omp_threads`, verbose)
}

setup_logger <- function(logname = "iscream") {
    invisible(.Call(`_iscream_setup_logger`, logname))
}

#' spdlog Logging Lever Setter
#'
#' A helper function to turn a logging level given as string
#' into the current logging level
#'
#' @param name A string with the logging level. Value understood are,
#' in decreasing verbosity \sQuote{trace}, \sQuote{debug}, \sQuote{info},
#' \sQuote{warning}, \sQuote{error}, \sQuote{critical}, and \sQuote{off}.
#' Unrecognised names are equivalent to \sQuote{off}.
#' @return Nothing is returned.
#' @keywords internal
Cpp_set_log_level <- function(name) {
    invisible(.Call(`_iscream_Cpp_set_log_level`, name))
}

#' @rdname set_log_level
#' @order 2
#' @export
get_log_level <- function() {
    .Call(`_iscream_get_log_level`)
}

#' Get htslib version and available features
#'
#' Returns the version of htslib being used by iscream and whether features
#' such as libdeflate support are available. This information may not always
#' correspond to the htslib version used during iscream's installation if a
#' different htslib version is available for linking at runtime.
#'
#' @returns None
#'
#' @examples
#' htslib_version()
#'
#' @export
htslib_version <- function() {
    invisible(.Call(`_iscream_htslib_version`))
}

Cpp_query_chroms <- function(bedfile_vec, nthreads) {
    .Call(`_iscream_Cpp_query_chroms`, bedfile_vec, nthreads)
}

Cpp_query_interval <- function(bedfile, regions) {
    .Call(`_iscream_Cpp_query_interval`, bedfile, regions)
}

scan_tabix <- function(bedfile, regions) {
    .Call(`_iscream_scan_tabix`, bedfile, regions)
}

#' Query all methylation info into M and coverage matrices
#' @param bedfiles A vector of BED files
#' @param regions A vector of regions
#' @param aligner The aligner used to make the WGBS BED files, only for
#' `make_mat_bsseq`
#' @param valInd The index of the data column needed for the matrix, for `make_mat`
#' @param merged Whether the input strands have been merged/collapsed
#' @param prealloc The number of rows to initialize the matrices with
#' @param nthreads Set number of threads to use overriding the
#' `"iscream.threads"` option. See `?set_threads` for more information.
#'
#' @returns A list of one or two matrices, chromosome, position, and filename vectors
#'
#' @keywords internal
Cpp_query_all <- function(bedfiles, regions, aligner, valInd, merged, sparse, prealloc, nthreads) {
    .Call(`_iscream_Cpp_query_all`, bedfiles, regions, aligner, valInd, merged, sparse, prealloc, nthreads)
}

#' Apply a function over BED file records within genomic features
#'
#' This function should be called from `summarize_regions()` since there are few
#' sanity checks on the C++ side.
#' @param bedfiles A vector of BED file paths
#' @param regions A vector of genomic regions
#' @param fun_vec Vector of the armadillo-supported stats functions to apply over the
#' CpGs in the ' regions: `"sum"`, `"mean"`, `"median"`, `"stddev"`,
#' `"variance"` "`count`", `"min"`,`"max"`, and `"range"`.
#' @param col_indices A vector of genomic regions
#' @param col_names A vector of genomic regions
#' @param mval Calculates M values when TRUE, use beta values when FALSE
#' @param region_rownames Whether to set rownames to the regions strings. Not
#' necessary if your regions vector is unnamed. If its names, then the "feature"
#' column is set to the names and the rownames are set to the regions string
#' @param nthreads Number of cores to use. See details.
#'
#' @details
#' The optimal number of threads depends on the number of bedfiles, but is set
#' to half the available OpenMP cores. See `?get_threads` for more details. It
#' can be manaully set with `set_threads()`.
#'
#' @returns A summary data.frame
#'
#' @keywords internal
Cpp_summarize_regions <- function(bedfiles, regions, fun_vec, col_indices, col_names, aligner, mval = FALSE, region_rownames = FALSE, nthreads = 1L) {
    .Call(`_iscream_Cpp_summarize_regions`, bedfiles, regions, fun_vec, col_indices, col_names, aligner, mval, region_rownames, nthreads)
}

