% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipdDbClass.R
\docType{class}
\name{IpdDb-class}
\alias{IpdDb-class}
\alias{.IpdDb}
\alias{IpdDb}
\alias{columns,IpdDb-method}
\alias{columns}
\alias{keytypes,IpdDb-method}
\alias{keytypes}
\alias{keys,IpdDb-method}
\alias{keys}
\alias{select,IpdDb-method}
\alias{select}
\title{The database class for storing allele data from IPD.}
\usage{
columns(x)

keytypes(x)

keys(x, keytype, ...)

select(x, keys, columns, keytype, ...)
}
\arguments{
\item{x}{the IpdDb object}

\item{keytype}{The keytype for which the keys are retrieved}

\item{...}{Additional arguments. Not used now.}

\item{keys}{The keys for which columns should be selected by select()}

\item{columns}{The columns to retrieve by select}
}
\value{
character vector (keys, columns, keytypes) or a data.frame (select).
}
\description{
This class extends the 
\code{\link[AnnotationDbi:AnnDbObj-class]{AnnotationDbi::AnnDbObj-class}}
object by higher level methods for sequence and annotation retrieval.
blubb
}
\section{Slots}{

\describe{
\item{\code{getDbVersion()}}{Get the version of the original ipd database}

\item{\code{getLoci()}}{get all loci from a database, see 
\code{\link{getLoci}}.}

\item{\code{getReference(alleles)}}{Get the reference sequence for alleles, see 
\code{\link{getReference}}.}

\item{\code{getStructure(alleles)}}{Get the structures of alleles, see 
\code{\link{getStructure}}.}

\item{\code{getClosestComplete(allele)}}{Get the closest full-length reference 
sequence of one allele, see \code{\link{getClosestComplete}}.}

\item{\code{getAlleles(locus)}}{Get all alleles of a locus, see 
\code{\link{getAlleles}}.}
}}


\examples{
## load the data 
hla <- loadHlaData()
## get all valid keytypes
kts <- keytypes(hla)
## get all valid columns
cols <- columns(hla)
## get the keys of one keytype
kt <- kts[1]
keys <- keys(hla, kt)
## Get data of the two first columns for the first 10 keys 
cols <- cols[1:10]
res <- select(hla, keys, cols, kt)
  
}
\seealso{
\code{\link[AnnotationDbi:AnnDbObj-class]{AnnotationDbi::AnnDbObj-class}}
}
