% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosGene}
\alias{CircosGene}
\title{GENE module}
\usage{
CircosGene(
  modulename,
  compareGroup = 1,
  outerRadius = 180,
  innerRadius = 150,
  pathColor = "black",
  pathWidth = 1,
  arrow = TRUE,
  arrowGap = 2,
  arrowColor = "blue",
  arrowSize = 5,
  cdsColor = "#1e77b3",
  cdsStrokeColor = "black",
  cdsStrokeWidth = 1,
  utrWidth = -5,
  utrColor = "blue",
  utrStrokeColor = "blue",
  utrStrokeWidth = 1,
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module}

\item{compareGroup}{The group number of this module in compare module}

\item{outerRadius, innerRadius}{Where the module should begin and end}

\item{pathColor}{The color for path between gene elements}

\item{pathWidth}{The width for path between gene elements}

\item{arrow}{Whether display arrows on path}

\item{arrowGap, arrowColor, arrowSize}{The gap, color and size for arrow}

\item{cdsColor, cdsStrokeColor, cdsStrokeWidth}{The color, stroke color and stroke width for coding}

\item{utrWidth, utrColor, utrStrokeColor, utrStrokeWidth}{The max size for bubble}

\item{animationDisplay}{Whether display animation}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of gene with details including chr, strand, start, end, type, name, link and html.
Details can be found on document}

\item{...}{Ignored}
}
\value{
The module tracks for gene modules
}
\description{
Create a number of genes with different functional region
}
\examples{
geneData<-geneExample
Circos(CircosGene('Gene01', outerRadius = 195, innerRadius = 180, data=geneData,arrowGap = 10,
 arrowColor = "black",arrowSize = "12px",cdsColor = "#1e77b3",cdsStrokeColor = "#1e77b3",
 cdsStrokeWidth= 5, utrWidth= -2,utrColor= "#fe7f0e",utrStrokeColor= "#fe7f0e",
 animationDisplay = TRUE),genome =list("EGFR"=1000), outerRadius = 220)

}
