% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosChord}
\alias{CircosChord}
\title{CHORD module of NG-Circos}
\usage{
CircosChord(
  modulename,
  innerRadius = 237,
  outerRadius = 238,
  fillOpacity = 0.67,
  fillStrokeWidth = 1,
  padding = 0.06,
  autoFillColor = TRUE,
  fillColor = c("#B8B8B8"),
  fillStrokeColor = c("black"),
  outerARC = TRUE,
  outerARCAutoColor = TRUE,
  outerARCColor = c("red"),
  outerARCStrokeColor = c("black"),
  outerARCText = TRUE,
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module}

\item{innerRadius}{The inner radius for chord circle}

\item{outerRadius}{The outer radius for chord circle}

\item{fillOpacity}{The opacity for filling color}

\item{fillStrokeWidth}{The stroke width for chord}

\item{padding}{The pad of chord}

\item{autoFillColor}{Whether auto assign color for chord}

\item{fillColor}{If not, manually assign color for chord}

\item{fillStrokeColor}{The color for stroke}

\item{outerARC}{Whether display outer arc}

\item{outerARCAutoColor}{If true, whether auto assign color for arc}

\item{outerARCColor}{The manullay assigned color for arc}

\item{outerARCStrokeColor}{The stroke color for arc}

\item{outerARCText}{Whether display text for arc or not}

\item{data}{A matrix-list of chord value with relationship details}

\item{...}{Ignored}
}
\value{
The module tracks for chord modules of NG-Circos
}
\description{
Create a chord module using a data matrix
}
\examples{

chordData<-chordExample
Circos(CircosChord('CHORD', data = chordData,innerRadius= 210,outerRadius= 211,fillOpacity=0.67,
strokeColor="black",strokeWidth= "1px",outerARCText=FALSE),genome=list("C.CK" = 189.51,"C.NPK"=188,
"GC.CK"=186.11, "GC.NPK"=191.51,"Alphaproteobacteria"=70.16,"Betaproteobacteria"=23.51,
"Gammaproteobacteria"=25.51, "Deltaproteobacteria"=23.28,"Acidobacteria"=53.62,
"Actinobacteria"=72.33, "Bacteroidetes"=22.41, "Chloroflexi"=15.08,"Firmicutes"=10.72,
"Gemmatimonadetes"=26.37, "Planctomycetes"=19.26,"Thaumarchaeota"=6.15, "Verrucomicrobia"=8.3,
"Ascomycota"=159.41, "Basidiomycota"=79.73,"Zygomycota"=139.29 ),outerRadius = 217, 
genomeLabelDisplay = FALSE)

}
